#include "General.h"
#include "ScopeCheatDetection.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "ScriptableGameObj.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "SoldierGameObj.h"
#include "gmgame.h"

HashTemplateClass<StringClass, int> ScopedWeaponsTable;
void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

ScopeCheatDetection::ScopeCheatDetection()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

ScopeCheatDetection::~ScopeCheatDetection()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void ScopeCheatDetection::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	int Count = SSGMIni->Entry_Count("ScopeCheatDetection_ScopedWeaponsList");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("ScopeCheatDetection_ScopedWeaponsList", i);
		StringClass Insert;
		SSGMIni->Get_String(Insert, "ScopeCheatDetection_ScopedWeaponsList", Entry);
		ScopedWeaponsTable.Insert(Entry, 1);
	}
/*	for (HashTemplateIterator<StringClass, int> iter(ScopedWeaponsTable); iter; ++iter)
	{ // DEBUG CRAP
		Console_Output("%s = %d\n", iter.getKey(), iter.getValue());
	} */
}

void ScopeCheatDetection::OnLoadLevel()
{
	GameObject* TimerObj = Commands->Create_Object("Invisible_Object", Vector3(0,0,0));
	Attach_Script_Once(TimerObj, "ScopeCheck_Script", "");
}

void Check_Scopes()
{
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = (cPlayer*) PlayerIter->Data();
		GameObject *obj = Get_GameObj(p->PlayerId);
		if (obj && (obj->As_SoldierGameObj()->Is_Sniping() == true))
		{
			const char* CurrentWeapon = Get_Current_Weapon(obj);
			if (CurrentWeapon && !ScopedWeaponsTable.Get(CurrentWeapon, 0))
			{
				Console_Output("[IRANSTUFF][Scope Warning]%S is scoped in holding %s.\n", p->PlayerName, CurrentWeapon);
			}
		}
	}
}

void ScopeCheck_Script::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, (float)5, 1);
}

void ScopeCheck_Script::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Check_Scopes();
		Commands->Start_Timer(obj, this, (float)5, 1);
	}
}

ScriptRegistrant<ScopeCheck_Script> ScopeCheck_Script_Registrant("ScopeCheck_Script", "");

ScopeCheatDetection scopeCheatDetection;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &scopeCheatDetection;
}
